//
//  PinchMeViewController.m
//  PinchMe
//
//  Created by Robert Górczyński on 11-07-26.
//

#import "PinchMeViewController.h"

@implementation PinchMeViewController
@synthesize label; 
@synthesize initialFontSize; 


// Implementacja metody viewDidLoad pozwala na przeprowadzenie konfiguracji po wczytaniu widoku, zazwyczaj z pliku nib.
- (void)viewDidLoad {
    [super viewDidLoad];

    UIPinchGestureRecognizer *pinch = [[[UIPinchGestureRecognizer alloc] 
										initWithTarget:self action:@selector(doPinch:)] autorelease]; 
    [self.view addGestureRecognizer:pinch]; 	
}

- (void)didReceiveMemoryWarning {
	// Jeżeli widok nie posiada widoku nadrzędnego, wówczas zostanie usunięty z pamięci.
    [super didReceiveMemoryWarning];
	
	// Usunięcie z pamięci wszelkich buforowanych danych, obrazów i innych zasobów, które obecnie nie są używane.
}

- (void)viewDidUnload {
	// Usunięcie wszystkich „przytrzymanych” podwidoków widoku głównego,
    // na przykład self.myOutlet = nil;
    self.label = nil; 
    [super viewDidUnload]; 
}


- (void)dealloc {
    [label release]; 
    [super dealloc];
}

- (void)doPinch:(UIPinchGestureRecognizer *)pinch { 
    if (pinch.state == UIGestureRecognizerStateBegan) { 
        initialFontSize = label.font.pointSize; 
    } else { 
        label.font = [label.font fontWithSize:initialFontSize * pinch.scale]; 
    }
} 

@end
